/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.FootprintBean;
import cds.aladin.PlanField;
import cds.aladin.Server;
import cds.aladin.SubFootprintBean;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerAlmaFootprint
extends Server {
    private List<ALMASetup> setups = new ArrayList<ALMASetup>();
    private JComboBox setupList;
    private JTextField widthField;
    private JTextField heightField;

    protected ServerAlmaFootprint(Aladin aladin) {
        this.aladin = aladin;
        this.init();
        this.createChaine();
        this.buildGUI();
    }

    protected void init() {
        this.type = 8;
        this.aladinMenu = "FoV...";
        this.aladinLabel = "ALMA footprint";
        this.aladinLogo = "ALMALogo.gif";
        this.grab = null;
        this.setups.add(new ALMASetup(3, 44.7f, new float[]{2.6f, 3.6f}, new float[]{84.0f, 116.0f}));
        this.setups.add(new ALMASetup(4, 30.9f, new float[]{1.8f, 2.4f}, new float[]{125.0f, 169.0f}));
        this.setups.add(new ALMASetup(5, 24.1f, new float[]{1.4f, 1.8f}, new float[]{163.0f, 211.0f}));
        this.setups.add(new ALMASetup(6, 18.9f, new float[]{1.1f, 1.4f}, new float[]{211.0f, 275.0f}));
        this.setups.add(new ALMASetup(7, 13.8f, new float[]{0.8f, 1.1f}, new float[]{275.0f, 373.0f}));
        this.setups.add(new ALMASetup(8, 10.3f, new float[]{0.6f, 0.8f}, new float[]{385.0f, 500.0f}));
        this.setups.add(new ALMASetup(9, 6.9f, new float[]{0.4f, 0.5f}, new float[]{602.0f, 720.0f}));
    }

    @Override
    protected void createChaine() {
        this.title = Aladin.chaine.getString("ALTITLE");
        this.description = Aladin.chaine.getString("ALINFO");
        super.createChaine();
    }

    private void buildGUI() {
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 50;
        int x = 150;
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, this.title);
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.description);
        l.setBounds(90, y += d.height + 10, 400, 20);
        y += 20;
        this.add(l);
        JPanel tPanel = new JPanel();
        tPanel.setBackground(Aladin.BLUE);
        int h = this.makeTargetPanel(tPanel, 2);
        tPanel.setBounds(0, y, XWIDTH, h);
        this.add(tPanel);
        this.modeCoo = 5;
        JLabel setuptTitle = new JLabel("Receiver band");
        setuptTitle.setBounds(10, y += h, 150, HAUT);
        this.add(setuptTitle);
        this.setupList = new JComboBox();
        for (ALMASetup almaSetup : this.setups) {
            this.setupList.addItem(almaSetup);
        }
        this.add(this.setupList);
        this.setupList.setBounds(160, y, XWIDTH - 160, HAUT);
        JLabel widthTitle = new JLabel("Width (arcmin)");
        widthTitle.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(widthTitle);
        this.widthField = new JTextField("5");
        this.add(this.widthField);
        this.widthField.setBounds(160, y, XWIDTH - 160, HAUT);
        JLabel heightTitle = new JLabel("Height (arcmin)");
        heightTitle.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(heightTitle);
        this.heightField = new JTextField("2");
        this.add(this.heightField);
        this.heightField.setBounds(160, y, XWIDTH - 160, HAUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit() {
        double height;
        double width;
        String t = this.getTarget();
        ALMASetup selectedSetup = (ALMASetup)this.setupList.getItemAt(this.setupList.getSelectedIndex());
        try {
            width = Double.parseDouble(this.widthField.getText()) / 60.0;
            height = Double.parseDouble(this.heightField.getText()) / 60.0;
        }
        catch (NumberFormatException nfe) {
            Aladin.error("Incorrect value for width/height !");
            return;
        }
        FootprintBean fpBean = new FootprintBean();
        float beam = selectedSetup.primaryBeam / 3600.0f;
        TreeSet<Point2D> centers = new TreeSet<Point2D>();
        double ymax = 0.0;
        int i = 0;
        while (true) {
            double d;
            double x = (double)((float)i * beam) * 0.5 * 0.5;
            if (!(d <= width / 2.0)) break;
            int j = 0;
            while (true) {
                double d2;
                double y = (double)((float)j * beam) * Math.sqrt(3.0) * 0.5;
                if (!(d2 <= height / 2.0 + (double)(beam / 2.0f))) break;
                if (i % 2 == 1) {
                    y += Math.sqrt(3.0) / 4.0 * (double)beam;
                }
                for (int k = 0; k < 4; ++k) {
                    int signX = k % 2 == 0 ? 1 : -1;
                    int signY = k < 2 ? 1 : -1;
                    centers.add(new Point2D((double)signX * x, (double)signY * y));
                    if (!(ymax < y)) continue;
                    ymax = y;
                }
                ++j;
            }
            ++i;
        }
        fpBean.addSubFootprintBean(new SubFootprintBean(new double[]{0.0, 0.0}, new double[]{0.0, ymax *= 1.3}, "handle"));
        fpBean.addSubFootprintBean(new SubFootprintBean(0.0, ymax, 270.0, 180.0, 0.0, 0.001, "handle"));
        for (Point2D center : centers) {
            fpBean.addSubFootprintBean(new SubFootprintBean(center.x, center.y, (double)beam / 2.0, null));
        }
        Calque calque = this.aladin.calque;
        synchronized (calque) {
            int idx = this.aladin.calque.newPlanField(fpBean, t, "ALMA", 0.0);
            ((PlanField)this.aladin.calque.plan[idx]).setIsAlmaFP(true);
            ((PlanField)this.aladin.calque.plan[idx]).setOpacityLevel(0.05f);
        }
    }

    public static class ALMASetup {
        int bandId;
        float primaryBeam;
        float[] wavelengthRange;
        float[] frequencyRange;

        public ALMASetup(int bandId, float primaryBeam, float[] wavelengthRange, float[] frequencyRange) {
            this.bandId = bandId;
            this.primaryBeam = primaryBeam;
            this.wavelengthRange = wavelengthRange;
            this.frequencyRange = frequencyRange;
        }

        public String toString() {
            return "Band " + this.bandId + " | " + this.wavelengthRange[0] + "-" + this.wavelengthRange[1] + " mm | " + this.frequencyRange[0] + "-" + this.frequencyRange[1] + " GHz";
        }
    }

    public static class Point2D
    implements Comparable<Point2D> {
        private double x;
        private double y;

        public Point2D(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Point2D)) {
                return false;
            }
            Point2D p = (Point2D)obj;
            return p.x == this.x && p.y == this.y;
        }

        @Override
        public int compareTo(Point2D p) {
            double eps = 1.0E-5;
            if (Math.abs(p.x - this.x) < eps && Math.abs(p.y - this.y) < eps) {
                return 0;
            }
            return 1;
        }
    }
}

